
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="ham sandwiches", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="kale salads", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="chicken drumsticks", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="bowls of cereal", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="hot dogs", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="cantaloupes", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(6.16*x0*x1 + 3.17*x0*x4 + 8.01*x1**2 + 5.61*x1*x3 + 9.03*x1*x4 + 4.95*x2*x4 + 9.57*x2*x5 + 6.49*x3**2 + 7.91*x0 + 6.47*x1 + 5.53*x3 + 9.15*x4 + 5.29*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.21*x0 + 0.05*x3 >= 18)
m.addConstr(0.05*x3**2 + x5**2 >= 10)
m.addConstr(3.21*x0 + 3.83*x4 >= 9)
m.addConstr(1.4*x2 + 0.05*x3 >= 14)
m.addConstr(0.05*x3**2 + x4**2 + x5**2 >= 17)
m.addConstr(3.24*x1 + 3.83*x4 + 1.57*x5 >= 17)
m.addConstr(0.05*x3 + 3.83*x4 + 1.57*x5 >= 10)
m.addConstr(0.05*x3**2 + x4**2 + x5**2 >= 10)
m.addConstr(4.39*x0 + 4.04*x2 >= 13)
m.addConstr(2.9*x1 + 4.04*x2 >= 14)
m.addConstr(2.9*x1 + 0.4*x5 >= 19)
m.addConstr(3.05*x4 + 0.4*x5 >= 18)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("ham sandwiches: ", x0.varValue)
    print("kale salads: ", x1.varValue)
    print("chicken drumsticks: ", x2.varValue)
    print("bowls of cereal: ", x3.varValue)
    print("hot dogs: ", x4.varValue)
    print("cantaloupes: ", x5.varValue)
else:
    print("The model is infeasible")
