
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")
dale = m.addVar(lb=0, vtype=GRB.INTEGER, name="dale")
hank = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")


# Set objective function
m.setObjective(1.91*george**2 + 6.38*george*dale + 5.02*george*hank + 5.74*george*bobby + 1.21*george*peggy + 9.69*dale**2 + 4.46*dale*bobby + 2.61*dale*peggy + 5.9*hank*bobby + 8.71*bobby**2 + 4.58*george + 2.71*dale + 4.65*hank + 7.06*peggy, GRB.MAXIMIZE)

# Add constraints
m.addConstr(23*hank**2 + 3*bobby**2 >= 23)
m.addConstr(23*george + 8*dale + 23*peggy >= 53)
m.addConstr(1*hank**2 + 15*bobby**2 + 15*peggy**2 >= 60)
m.addConstr(10*george**2 + 16*dale**2 + 15*bobby**2 >= 60)
m.addConstr(10*george + 16*dale + 1*hank >= 60)
m.addConstr(10*george**2 + 1*hank**2 + 15*peggy**2 >= 60)
m.addConstr(16*dale + 15*bobby + 15*peggy >= 60)
m.addConstr(1*hank**2 + 15*bobby**2 + 15*peggy**2 >= 82)
m.addConstr(10*george + 16*dale + 15*bobby >= 82)
m.addConstr(10*george + 16*dale + 1*hank >= 82)
m.addConstr(10*george**2 + 1*hank**2 + 15*peggy**2 >= 82)
m.addConstr(16*dale + 15*bobby + 15*peggy >= 82)
m.addConstr(1*hank + 15*bobby + 15*peggy >= 98)
m.addConstr(10*george + 16*dale + 15*bobby >= 98)
m.addConstr(10*george**2 + 16*dale**2 + 1*hank**2 >= 98)
m.addConstr(10*george + 1*hank + 15*peggy >= 98)
m.addConstr(16*dale + 15*bobby + 15*peggy >= 98)
m.addConstr(1*hank + 15*bobby + 15*peggy >= 63)
m.addConstr(10*george**2 + 16*dale**2 + 15*bobby**2 >= 63)
m.addConstr(10*george**2 + 16*dale**2 + 1*hank**2 >= 63)
m.addConstr(10*george + 1*hank + 15*peggy >= 63)
m.addConstr(16*dale**2 + 15*bobby**2 + 15*peggy**2 >= 63)
m.addConstr(1*hank**2 + 15*bobby**2 + 15*peggy**2 >= 56)
m.addConstr(10*george + 16*dale + 15*bobby >= 56)
m.addConstr(10*george + 16*dale + 1*hank >= 56)
m.addConstr(10*george**2 + 1*hank**2 + 15*peggy**2 >= 56)
m.addConstr(16*dale + 15*bobby + 15*peggy >= 56)
m.addConstr(11*hank + 23*peggy <= 178)
m.addConstr(8*dale + 23*peggy <= 84)
m.addConstr(23*george**2 + 11*hank**2 <= 282)
m.addConstr(23*george + 23*peggy <= 304)
m.addConstr(23*george + 3*bobby <= 337)
m.addConstr(23*george + 8*dale <= 128)
m.addConstr(11*hank**2 + 3*bobby**2 <= 317)
m.addConstr(8*dale**2 + 3*bobby**2 + 23*peggy**2 <= 145)
m.addConstr(23*george + 8*dale + 23*peggy <= 106)
m.addConstr(11*hank + 3*bobby + 23*peggy <= 243)
m.addConstr(8*dale + 11*hank + 23*peggy <= 153)
m.addConstr(23*george + 11*hank + 23*peggy <= 71)
m.addConstr(23*george + 3*bobby + 23*peggy <= 282)
m.addConstr(23*george + 8*dale + 3*bobby <= 256)
m.addConstr(8*dale + 11*hank + 3*bobby <= 221)
m.addConstr(23*george + 8*dale + 11*hank + 3*bobby + 23*peggy <= 221)
m.addConstr(15*bobby + 15*peggy <= 399)
m.addConstr(16*dale + 15*bobby <= 123)
m.addConstr(10*george + 15*bobby + 15*peggy <= 272)
m.addConstr(16*dale + 1*hank + 15*peggy <= 175)
m.addConstr(10*george + 16*dale + 1*hank <= 401)
m.addConstr(16*dale**2 + 15*bobby**2 + 15*peggy**2 <= 325)
m.addConstr(16*dale + 1*hank + 15*bobby <= 139)
m.addConstr(10*george + 16*dale + 1*hank + 15*bobby + 15*peggy <= 139)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

