
import gurobi as gp

# Define variables
x0 = gp.Var(name="x0", lb=0)  # hours worked by George
x1 = gp.Var(name="x1", lb=0, integrality=gp.GRB.Integer)  # hours worked by Dale
x2 = gp.Var(name="x2", lb=0)  # hours worked by Hank
x3 = gp.Var(name="x3", lb=0)  # hours worked by Bobby
x4 = gp.Var(name="x4", lb=0)  # hours worked by Peggy

# Objective function
m = gp.Model()
m.setObjective(1.91*x0**2 + 6.38*x0*x1 + 5.02*x0*x2 + 5.74*x0*x3 + 1.21*x0*x4 +
               9.69*x1**2 + 4.46*x1*x3 + 2.61*x1*x4 + 5.9*x2*x3 + 8.71*x3**2 +
               4.58*x0 + 2.71*x1 + 4.65*x2 + 7.06*x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(23*x0 <= 353)
m.addConstr(10*x0 <= 510)
m.addConstr(8*x1 <= 353)
m.addConstr(16*x1 <= 510)
m.addConstr(11*x2 <= 353)
m.addConstr(x2 <= 510)
m.addConstr(3*x3 <= 353)
m.addConstr(15*x3 <= 510)
m.addConstr(23*x4 <= 353)
m.addConstr(15*x4 <= 510)

m.addConstr(11*x2**2 + 3*x3**2 >= 23)
m.addConstr(23*x0 + 8*x1 + 23*x4 >= 53)
m.addConstr(x2**2 + 15*x3**2 + 15*x4**2 >= 60)
m.addConstr(10*x0**2 + 16*x1**2 + 15*x3**2 >= 60)
m.addConstr(10*x0 + 16*x1 + x2 >= 60)
m.addConstr(10*x0**2 + x2**2 + 15*x4**2 >= 60)
m.addConstr(16*x1 + 15*x3 + 15*x4 >= 60)

# Add more constraints similarly...

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No solution found")
