
import gurobi as gp

# Define variables
x = gp.mvar(7, lb=0, name="x")

# Define objective function
obj = 5.22*x[0]**2 + 6.73*x[0]*x[1] + 9.17*x[0]*x[2] + 5.19*x[0]*x[4] + 3.25*x[0]*x[5] + 5.04*x[0]*x[6] + \
    6.22*x[1]**2 + 9.78*x[1]*x[2] + 3.43*x[1]*x[3] + 8.49*x[1]*x[5] + 6.39*x[1]*x[6] + 4.26*x[2]**2 + \
    4.82*x[2]*x[3] + 7.34*x[2]*x[5] + 1.76*x[2]*x[6] + 8.48*x[3]**2 + 7.22*x[3]*x[4] + 3.21*x[3]*x[5] + \
    1.92*x[4]**2 + 6.13*x[4]*x[5] + 2.2*x[4]*x[6] + 9.46*x[5]**2 + 9.24*x[6]**2 + 9.85*x[0] + 1.76*x[1] + \
    7.06*x[2] + 6.39*x[3] + 3.37*x[4] + 7.7*x[5] + 5.06*x[6]

# Define model
m = gp.Model()
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
# Organization score
m.addConstr(3*x[0] == 3)
m.addConstr(12*x[1] == 12)
m.addConstr(4*x[2] == 4)
m.addConstr(9*x[3] == 9)
m.addConstr(8*x[4] == 8)
m.addConstr(8*x[5] == 8)
m.addConstr(17*x[6] == 17)

# Computer competence rating
m.addConstr(10*x[0] == 10)
m.addConstr(3*x[1] == 3)
m.addConstr(7*x[2] == 7)
m.addConstr(15*x[3] == 15)
m.addConstr(2*x[4] == 2)
m.addConstr(21*x[5] == 21)
m.addConstr(10*x[6] == 10)

# Work quality rating
m.addConstr(9*x[0] == 9)
m.addConstr(15*x[1] == 15)
m.addConstr(6*x[2] == 6)
m.addConstr(14*x[3] == 14)
m.addConstr(4*x[4] == 4)
m.addConstr(19*x[5] == 19)
m.addConstr(24*x[6] == 24)

# Likelihood to quit index
m.addConstr(18*x[0] == 18)
m.addConstr(21*x[1] == 21)
m.addConstr(11*x[2] == 11)
m.addConstr(2*x[3] == 2)
m.addConstr(21*x[4] == 21)
m.addConstr(25*x[5] == 25)
m.addConstr(3*x[6] == 3)

# Other constraints...
m.addConstr(12*x[1] + 9*x[3] >= 51)

# Solve model
m.optimize()

if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print("Objective: ", m.objVal)
    for i in range(7):
        print(f"x[{i}] = {x[i].x}")
else:
    print("No optimal solution found.")
