
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(9, lb=0, vtype=gp.GRB.CONTINUOUS, name=["x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8"])


# Set objective function
m.setObjective(9*x[0] + 6*x[1] + 2*x[2] + 1*x[3] + 1*x[4] + 3*x[5] + 4*x[6] + 6*x[7] + 6*x[8], gp.GRB.MINIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': [6.04, 4.69, 12.59, 9.8, 4.7, 5.22, 13.5, 5.95, 10.0],
    'r1': [9.51, 10.11, 9.63, 5.47, 9.91, 6.24, 12.88, 3.72, 3.69],
    'r2': [4.27, 6.71, 11.63, 0.06, 4.92, 4.65, 8.76, 2.26, 12.88]
}

# Resource upper bounds
resource_bounds = {
    'r0': 181,
    'r1': 230,
    'r2': 178
}

# Add resource constraints
for r, coeffs in resource_coeffs.items():
    m.addConstr(gp.quicksum(coeffs[i] * x[i] for i in range(9)) <= resource_bounds[r], name=r)


# Add additional constraints from the input
with open('constraints.txt', 'r') as file:  # Assuming constraints are stored in constraints.txt
    for line in file:
        constraint = line.strip()
        if constraint:  # Check for empty lines
            try:
                lhs, op, rhs = constraint.split()
                lhs_expr = eval(lhs, {}, {'x': x})  # Evaluate LHS expression
                rhs_val = float(rhs)
                if op == '>=':
                    m.addConstr(lhs_expr >= rhs_val)
                elif op == '<=':
                    m.addConstr(lhs_expr <= rhs_val)
                elif op == '=':
                    m.addConstr(lhs_expr == rhs_val)
                else:
                    print(f"Invalid operator: {op}")
            except Exception as e:
                print(f"Error processing constraint: {constraint}")
                print(e)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    m.write("model.ilp")
    print('\nThe following constraint(s) cannot be satisfied:')
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
else:
    print('Optimization was stopped with status %d' % m.status)

