
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    paul = model.addVar(lb=0, name="paul")  # hours worked by Paul
    hank = model.addVar(lb=0, name="hank")  # hours worked by Hank
    laura = model.addVar(lb=0, name="laura") # hours worked by Laura


    # Set objective function
    obj = paul**2 + 8*paul*hank + 2*paul*laura + 9*hank**2 + 5*hank*laura + 2*laura**2 + 9*paul + 2*hank
    model.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(17*paul + 15*hank + 12*laura <= 240, "c0") # Work quality
    model.addConstr(9*paul + 9*hank + 5*laura <= 284, "c1") # Paperwork competence
    model.addConstr(9*paul**2 + 9*hank**2 >= 76, "c2")
    model.addConstr(9*hank**2 + 5*laura**2 >= 61, "c3")
    model.addConstr(15*hank + 12*laura <= 190, "c4")
    model.addConstr(17*paul + 15*hank <= 108, "c5")
    model.addConstr(17*paul + 15*hank + 12*laura <= 108, "c6")
    model.addConstr(9*hank + 5*laura <= 191, "c7")
    model.addConstr(9*paul + 9*hank <= 250, "c8")
    model.addConstr(9*paul**2 + 5*laura**2 <= 207, "c9")
    model.addConstr(9*paul + 9*hank + 5*laura <= 207, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Paul: %g' % paul.x)
        print('Hank: %g' % hank.x)
        print('Laura: %g' % laura.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
