
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    
    # Objective function
    model.setObjective(1*x0**2 + 8*x0*x1 + 2*x0*x2 + 9*x1**2 + 5*x1*x2 + 2*x2**2 + 9*x0 + 2*x1, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(9*x0**2 + 9*x1**2 >= 76, name="c1")
    model.addConstr(9*x1**2 + 5*x2**2 >= 61, name="c2")
    model.addConstr(15*x1 + 12*x2 <= 190, name="c3")
    model.addConstr(17*x0 + 15*x1 <= 108, name="c4")
    model.addConstr(17*x0 + 15*x1 + 12*x2 <= 108, name="c5")
    model.addConstr(9*x1 + 5*x2 <= 191, name="c6")
    model.addConstr(9*x0 + 9*x1 <= 250, name="c7")
    model.addConstr(9*x0**2 + 5*x2**2 <= 207, name="c8")
    model.addConstr(9*x0 + 9*x1 + 5*x2 <= 207, name="c9")
    
    # Given ratings as constraints
    model.addConstr(17*x0 == 240, name="c10")
    #model.addConstr(9*x0 == 284, name="c11") # This will make c10 infeasible
    model.addConstr(15*x1 == 240, name="c12")
    #model.addConstr(9*x1 == 284, name="c13") # This will make c12 infeasible
    model.addConstr(12*x2 == 240, name="c14")
    #model.addConstr(5*x2 == 284, name="c15") # This will make c14 infeasible
    
    # Solve the model
    model.optimize()
    
    # Print the status
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)

optimize_problem()
