
import gurobi as gp

# Define the model
model = gp.Model("Optimization Problem")

# Define the variables
x0 = model.addVar(name="x0", lb=-gp.GRB.INFINITY)  
x1 = model.addVar(name="x1", lb=-gp.GRB.INFINITY)  
x2 = model.addVar(name="x2", lb=-gp.GRB.INFINITY)  
x3 = model.addVar(name="x3", lb=0, type=gp.GRB.INTEGER)  
x4 = model.addVar(name="x4", lb=-gp.GRB.INFINITY)  
x5 = model.addVar(name="x5", lb=-gp.GRB.INFINITY)  

# Objective function
model.setObjective(2.37*x0**2 + 6.17*x0*x1 + 1.13*x0*x2 + 2.53*x0*x3 + 8.75*x0*x4 + 
                   6.78*x1**2 + 4.52*x1*x2 + 9.5*x1*x3 + 8.49*x1*x4 + 3.58*x1*x5 + 
                   4.18*x2**2 + 4.88*x2*x3 + 3.82*x2*x4 + 9.6*x3**2 + 5.47*x3*x4 + 
                   3.79*x3*x5 + 3.65*x4*x5 + 9.25*x5**2 + 9.46*x0 + 2.03*x1 + 
                   9.34*x2 + 7.69*x3 + 6.98*x4 + 7.05*x5, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(9*x0 + 17*x1 + 2*x2 + 9*x3 + 16*x4 + 14*x5 >= 18)
model.addConstr(9*x0 + 17*x1 + 2*x2 + 9*x3 >= 18)
model.addConstr(17*x1 + 2*x2 + 9*x3 >= 18)
model.addConstr(9*x0**2 + 17*x1**2 + 2*x2**2 >= 25)
model.addConstr(9*x0**2 + 17*x1**2 + 9*x3**2 >= 25)
model.addConstr(17*x1**2 + 2*x2**2 + 9*x3**2 >= 25)
model.addConstr(9*x0 + 17*x1 + 2*x2 >= 20)
model.addConstr(20*x0 + 11*x1 + x2 + 10*x3 + 14*x4 + 3*x5 <= 399)
model.addConstr(20*x0 + 11*x1 + x2 + 10*x3 + 14*x4 + 3*x5 >= 37)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Objective: ", model.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No optimal solution found.")
