
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    laura_hours = m.addVar(lb=0, name="laura_hours")
    ringo_hours = m.addVar(lb=0, name="ringo_hours")
    jean_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="jean_hours")


    # Set objective function
    m.setObjective(3*laura_hours*ringo_hours + 6*laura_hours + 2*ringo_hours, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.4*ringo_hours + 3.79*jean_hours >= 15)
    m.addConstr(15.55*laura_hours**2 + 1.4*ringo_hours**2 >= 12)
    m.addConstr(15.55*laura_hours**2 + 1.4*ringo_hours**2 + 3.79*jean_hours**2 >= 13)
    m.addConstr(15.55*laura_hours + 1.4*ringo_hours + 3.79*jean_hours >= 13)
    m.addConstr(11.52*laura_hours + 8.25*ringo_hours >= 21)
    m.addConstr(11.52*laura_hours + 8.25*ringo_hours + 14.56*jean_hours >= 21)
    m.addConstr(8.96*laura_hours + 10.83*jean_hours >= 34)
    m.addConstr(9.37*ringo_hours + 10.83*jean_hours >= 15)
    m.addConstr(8.96*laura_hours + 9.37*ringo_hours + 10.83*jean_hours >= 35)
    m.addConstr(-4*ringo_hours + 6*jean_hours >= 0)
    m.addConstr(-4*laura_hours**2 + 4*ringo_hours**2 >= 0)
    m.addConstr(15.55*laura_hours + 1.4*ringo_hours <= 58)
    m.addConstr(11.52*laura_hours + 8.25*ringo_hours <= 32)
    m.addConstr(8.96*laura_hours + 10.83*jean_hours <= 125)
    m.addConstr(9.37*ringo_hours**2 + 10.83*jean_hours**2 <= 63)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
