
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Laura
x1 = m.addVar(name="x1", lb=0)  # hours worked by Ringo
x2 = m.addVar(name="x2", lb=0, integrality=1)  # hours worked by Jean

# Objective function
m.setObjective(3 * x0 * x1 + 6 * x0 + 2 * x1, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(1.4 * x1 + 3.79 * x2 >= 15)
m.addConstr(15.55**2 * x0**2 + 1.4**2 * x1**2 >= 12)
m.addConstr(15.55**2 * x0**2 + 1.4**2 * x1**2 + 3.79**2 * x2**2 >= 13)
m.addConstr(15.55 * x0 + 1.4 * x1 + 3.79 * x2 >= 13)
m.addConstr(11.52 * x0 + 8.25 * x1 >= 21)
m.addConstr(11.52 * x0 + 8.25 * x1 + 14.56 * x2 >= 21)
m.addConstr(8.96 * x0 + 10.83 * x2 >= 34)
m.addConstr(9.37 * x1 + 10.83 * x2 >= 15)
m.addConstr(8.96 * x0 + 9.37 * x1 + 10.83 * x2 >= 35)
m.addConstr(-4 * x1 + 6 * x2 >= 0)
m.addConstr(-4 * x0**2 + 4 * x1**2 >= 0)
m.addConstr(15.55 * x0 + 1.4 * x1 <= 58)
m.addConstr(11.52 * x0 + 8.25 * x1 <= 32)
m.addConstr(8.96 * x0 + 10.83 * x2 <= 125)
m.addConstr(9.37**2 * x1**2 + 10.83**2 * x2**2 <= 63)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
