
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
dale = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
laura = model.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
paul = model.addVar(vtype=gp.GRB.CONTINUOUS, name="paul")
george = model.addVar(vtype=gp.GRB.CONTINUOUS, name="george")


# Set objective function
model.setObjective(3*ringo**2 + 8*dale**2 + 2*dale*george + 6*laura*george + 2*paul**2 + 3*laura + 3*paul, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9*dale + 3*laura >= 51)
model.addConstr(3*laura**2 + 9*george**2 >= 18)
model.addConstr(8*paul**2 + 9*george**2 >= 27)
model.addConstr(dale + 9*george >= 47)
model.addConstr(dale + 8*paul >= 24)
model.addConstr(3*laura + 8*paul >= 55)
model.addConstr(9*ringo**2 + 9*george**2 >= 42)
model.addConstr(10*dale + 4*george >= 27)
model.addConstr(2*dale - laura + 2*paul >= 0)
model.addConstr(9*ringo + 3*laura <= 238)
model.addConstr(3*laura + 8*paul <= 255)
model.addConstr(9*ringo**2 + dale**2 + 8*paul**2 <= 242)
model.addConstr(9*ringo**2 + 8*paul**2 + 9*george**2 <= 169)
model.addConstr(9*ringo + dale + 3*laura <= 175)
model.addConstr(dale**2 + 3*laura**2 + 9*george**2 <= 137)
model.addConstr(9*ringo + dale + 9*george <= 191)
model.addConstr(9*ringo + dale + 3*laura + 8*paul + 9*george <= 191)
model.addConstr(ringo + 2*paul <= 146)
model.addConstr(10*dale + 4*george <= 239)
model.addConstr(ringo + 3*laura <= 130)
model.addConstr(2*paul**2 + 4*george**2 <= 101)
model.addConstr(ringo + 4*george <= 230)
model.addConstr(10*dale + 2*paul <= 51)
model.addConstr(10*dale**2 + 3*laura**2 <= 147)
model.addConstr(ringo + 10*dale + 3*laura + 2*paul + 4*george <= 147)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

