
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Ringo
x1 = model.addVar(name='x1', lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS)  # Dale
x2 = model.addVar(name='x2', lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS)  # Laura
x3 = model.addVar(name='x3', lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS)  # Paul
x4 = model.addVar(name='x4', lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS)  # George

# Objective function
model.setObjective(3*x0**2 + 8*x1**2 + 2*x1*x4 + 6*x2*x4 + 2*x3**2 + 3*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Constraints
# Ringo's work quality rating is 9
model.addConstr(x0 == 1, name='c1')
# Ringo's likelihood to quit index is 1
model.addConstr(x0 == 1, name='c2')
# Dale's work quality rating is 1
model.addConstr(x1 == 1, name='c3')
# Dale's likelihood to quit index is 10
model.addConstr(10*x1 == 10, name='c4')
# Laura's work quality rating is 3
model.addConstr(3*x2 == 3, name='c5')
# Laura's likelihood to quit index is 3
model.addConstr(3*x2 == 3, name='c6')
# Paul's work quality rating is 8
model.addConstr(8*x3 == 8, name='c7')
# Paul's likelihood to quit index is 2
model.addConstr(2*x3 == 2, name='c8')
# George's work quality rating is 9
model.addConstr(9*x4 == 9, name='c9')
# George's likelihood to quit index is 4
model.addConstr(4*x4 == 4, name='c10')

model.addConstr(x1 + 3*x2 >= 51, name='c11')
model.addConstr(9*x2**2 + 9*x4**2 >= 18, name='c12')
model.addConstr(64*x3**2 + 81*x4**2 >= 27, name='c13')
model.addConstr(x1 + 9*x4 >= 47, name='c14')
model.addConstr(x1 + 8*x3 >= 24, name='c15')
model.addConstr(3*x2 + 8*x3 >= 55, name='c16')
model.addConstr(81*x0**2 + 81*x4**2 >= 42, name='c17')
model.addConstr(10*x1 + 4*x4 >= 27, name='c18')
model.addConstr(2*x1 - x2 + 2*x3 >= 0, name='c19')
model.addConstr(9*x0 + 3*x2 <= 238, name='c20')
model.addConstr(3*x2 + 8*x3 <= 255, name='c21')
model.addConstr(81*x0**2 + x1**2 + 64*x3**2 <= 242, name='c22')
model.addConstr(81*x0**2 + 64*x3**2 + 81*x4**2 <= 169, name='c23')
model.addConstr(9*x0 + x1 + 3*x2 <= 175, name='c24')
model.addConstr(x1**2 + 9*x2**2 + 81*x4**2 <= 137, name='c25')
model.addConstr(9*x0 + x1 + 9*x4 <= 191, name='c26')
model.addConstr(9*x0 + x1 + 3*x2 + 8*x3 + 9*x4 <= 191, name='c27')
model.addConstr(x0 + 2*x3 <= 146, name='c28')
model.addConstr(10*x1 + 4*x4 <= 239, name='c29')
model.addConstr(x0 + 3*x2 <= 130, name='c30')
model.addConstr(4*x3**2 + 16*x4**2 <= 101, name='c31')
model.addConstr(x0 + 4*x4 <= 230, name='c32')
model.addConstr(10*x1 + 2*x3 <= 51, name='c33')
model.addConstr(100*x1**2 + 9*x2**2 <= 147, name='c34')
model.addConstr(x0 + 10*x1 + 3*x2 + 2*x3 + 4*x4 <= 147, name='c35')

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
