
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b2")
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")

    # Set objective function
    m.setObjective(9*zinc + 4*vitamin_b2 + 7*vitamin_b3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*zinc + 19*vitamin_b2 + 3*vitamin_b3 <= 132, "immune_support_ub")
    m.addConstr(7*zinc + 19*vitamin_b2 + 16*vitamin_b3 <= 219, "muscle_growth_ub")
    m.addConstr(6*zinc + 9*vitamin_b2 + 19*vitamin_b3 <= 416, "digestive_support_ub")

    m.addConstr(9*zinc + 3*vitamin_b3 >= 32, "immune_support1_lb")
    m.addConstr(9*zinc + 19*vitamin_b2 >= 34, "immune_support2_lb")
    m.addConstr(9*zinc + 19*vitamin_b2 + 3*vitamin_b3 >= 34, "immune_support3_lb")

    m.addConstr(7*zinc + 19*vitamin_b2 >= 69, "muscle_growth1_lb")
    m.addConstr(19*vitamin_b2 + 16*vitamin_b3 >= 29, "muscle_growth2_lb")
    m.addConstr(7*zinc + 19*vitamin_b2 + 16*vitamin_b3 >= 29, "muscle_growth3_lb")

    m.addConstr(9*vitamin_b2 + 19*vitamin_b3 >= 97, "digestive_support1_lb")
    m.addConstr(6*zinc + 19*vitamin_b3 >= 71, "digestive_support2_lb")
    m.addConstr(6*zinc + 9*vitamin_b2 + 19*vitamin_b3 >= 71, "digestive_support3_lb")

    m.addConstr(8*vitamin_b2 - 2*vitamin_b3 >= 0, "constraint1")
    m.addConstr(10*zinc - 4*vitamin_b2 >= 0, "constraint2")

    m.addConstr(9*zinc + 19*vitamin_b2 + 3*vitamin_b3 <= 114, "immune_support_total_ub")
    m.addConstr(7*zinc + 19*vitamin_b2 <= 122, "muscle_growth_zinc_b2_ub")
    m.addConstr(7*zinc + 16*vitamin_b3 <= 218, "muscle_growth_zinc_b3_ub")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', zinc.x)
        print('vitamin_b2:', vitamin_b2.x)
        print('vitamin_b3:', vitamin_b3.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
