
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="milligrams_of_zinc", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="milligrams_of_vitamin_B2", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="milligrams_of_vitamin_B3", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(9 * x0 + 4 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x0 <= 132)
    model.addConstr(7 * x0 <= 219)
    model.addConstr(6 * x0 <= 416)
    model.addConstr(19 * x1 <= 132)
    model.addConstr(19 * x1 <= 219)
    model.addConstr(9 * x1 <= 416)
    model.addConstr(3 * x2 <= 132)
    model.addConstr(16 * x2 <= 219)
    model.addConstr(19 * x2 <= 416)
    model.addConstr(9 * x0 + 3 * x2 >= 32)
    model.addConstr(9 * x0 + 19 * x1 >= 34)
    model.addConstr(9 * x0 + 19 * x1 + 3 * x2 >= 34)
    model.addConstr(7 * x0 + 19 * x1 >= 69)
    model.addConstr(19 * x1 + 16 * x2 >= 29)
    model.addConstr(7 * x0 + 19 * x1 + 16 * x2 >= 29)
    model.addConstr(9 * x1 + 19 * x2 >= 97)
    model.addConstr(6 * x0 + 19 * x2 >= 71)
    model.addConstr(6 * x0 + 9 * x1 + 19 * x2 >= 71)
    model.addConstr(8 * x1 - 2 * x2 >= 0)
    model.addConstr(10 * x0 - 4 * x1 >= 0)
    model.addConstr(9 * x0 + 19 * x1 + 3 * x2 <= 114)
    model.addConstr(7 * x0 + 19 * x1 <= 122)
    model.addConstr(7 * x0 + 16 * x2 <= 218)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of vitamin B3: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize()
