
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")


    # Set objective function
    m.setObjective(6*oreos + 8*lemons + 3*pickles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*oreos + 1*lemons + 6*pickles <= 43, "c0")
    m.addConstr(2*oreos + 8*lemons + 1*pickles <= 34, "c1")
    m.addConstr(1*lemons + 6*pickles >= 10, "c2")
    m.addConstr(7*oreos + 1*lemons >= 4, "c3")
    m.addConstr(7*oreos + 1*lemons + 6*pickles >= 4, "c4")
    m.addConstr(8*lemons + 1*pickles >= 7, "c5")
    m.addConstr(2*oreos + 8*lemons >= 9, "c6")
    m.addConstr(2*oreos + 8*lemons + 1*pickles >= 9, "c7")
    m.addConstr(4*lemons - 7*pickles >= 0, "c8")
    m.addConstr(7*oreos + 1*lemons <= 22, "c9")
    m.addConstr(1*lemons + 6*pickles <= 29, "c10")
    m.addConstr(8*lemons + 1*pickles <= 25, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Oreos:', oreos.x)
        print('Lemons:', lemons.x)
        print('Pickles:', pickles.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
