
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")

# Set the objective function
m.setObjective(6*x0 + 8*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 10/1, "Calcium_from_lemons_and_pickles")
m.addConstr(7*x0 + x1 >= 4, "Calcium_from_oreos_and_lemons")
m.addConstr(7*x0 + x1 + 6*x2 >= 4, "Calcium_from_all")
m.addConstr(8*x1 + x2 >= 7, "Healthiness_rating_from_lemons_and_pickles")
m.addConstr(2*x0 + 8*x1 >= 9, "Healthiness_rating_from_oreos_and_lemons")
m.addConstr(2*x0 + 8*x1 + x2 >= 9, "Healthiness_rating_from_all")
m.addConstr(4*x1 - 7*x2 >= 0, "Lemons_pickles_ratio")
m.addConstr(7*x0 + x1 <= 22, "Calcium_limit_oreos_lemons")
m.addConstr(x1 + 6*x2 <= 29, "Calcium_limit_lemons_pickles")
m.addConstr(8*x1 + x2 <= 25, "Healthiness_rating_limit_lemons_pickles")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oreos: {x0.x}, Lemons: {x1.x}, Pickles: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
