
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    oreos = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="oreos")
    lemons = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="lemons")
    pickles = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="pickles")

    # Objective function
    model.setObjective(6 * oreos + 8 * lemons + 3 * pickles, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(lemons + pickles >= 10, name="calcium_from_lemons_pickles")
    model.addConstr(7 * oreos + lemons >= 4, name="calcium_from_oreos_lemons")
    model.addConstr(7 * oreos + lemons + 6 * pickles >= 4, name="calcium_from_all")
    model.addConstr(8 * lemons + pickles >= 7, name="healthiness_from_lemons_pickles")
    model.addConstr(2 * oreos + 8 * lemons >= 9, name="healthiness_from_oreos_lemons")
    model.addConstr(2 * oreos + 8 * lemons + pickles >= 9, name="healthiness_from_all")
    model.addConstr(4 * lemons - 7 * pickles >= 0, name="lemons_pickles_relation")
    model.addConstr(7 * oreos + lemons <= 22, name="calcium_limit_oreos_lemons")
    model.addConstr(lemons + 6 * pickles <= 29, name="calcium_limit_lemons_pickles")
    model.addConstr(8 * lemons + pickles <= 25, name="healthiness_limit_lemons_pickles")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Oreos: ", oreos.x)
        print("Lemons: ", lemons.x)
        print("Pickles: ", pickles.x)
    else:
        print("No optimal solution found")

optimize_problem()
