
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
    dale = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale")

    # Set objective function
    model.setObjective(6*hank + 1*peggy + 1*paul + 4*dale, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*peggy + 7*paul >= 38)
    model.addConstr(10*hank + 7*paul >= 35)
    model.addConstr(7*paul + 20*dale >= 30)
    model.addConstr(10*hank + 7*peggy + 7*paul + 20*dale >= 30)
    model.addConstr(9*hank + 15*peggy >= 25)
    model.addConstr(15*peggy + 23*dale >= 29)
    model.addConstr(9*hank + 21*paul >= 37)
    model.addConstr(9*hank + 21*paul + 23*dale >= 44)
    model.addConstr(9*hank + 15*peggy + 21*paul >= 44)
    model.addConstr(9*hank + 21*paul + 23*dale >= 32)
    model.addConstr(9*hank + 15*peggy + 21*paul >= 32)
    model.addConstr(9*hank + 15*peggy + 21*paul + 23*dale >= 32)
    model.addConstr(-9*hank + 7*paul >= 0)
    model.addConstr(7*hank - 9*peggy >= 0)
    model.addConstr(10*hank + 7*paul + 20*dale <= 63)
    model.addConstr(7*peggy + 7*paul + 20*dale <= 134)
    model.addConstr(9*hank + 23*dale <= 65)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
