
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="Hank", lb=0)
x1 = m.addVar(name="Peggy", lb=0)
x2 = m.addVar(name="Paul", lb=0)
x3 = m.addVar(name="Dale", lb=0, integrality=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6 * x0 + x1 + x2 + 4 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(10 * x0 <= 168)
m.addConstr(9 * x0 <= 190)
m.addConstr(7 * x1 <= 168)
m.addConstr(15 * x1 <= 190)
m.addConstr(7 * x2 <= 168)
m.addConstr(21 * x2 <= 190)
m.addConstr(20 * x3 <= 168)
m.addConstr(23 * x3 <= 190)

m.addConstr(7 * x1 + 7 * x2 >= 38)
m.addConstr(10 * x0 + 7 * x2 >= 35)
m.addConstr(7 * x2 + 20 * x3 >= 30)
m.addConstr(10 * x0 + 7 * x1 + 7 * x2 + 20 * x3 >= 30)

m.addConstr(9 * x0 + 15 * x1 >= 25)
m.addConstr(15 * x1 + 23 * x3 >= 29)
m.addConstr(9 * x0 + 21 * x2 >= 37)
m.addConstr(9 * x0 + 21 * x2 + 23 * x3 >= 44)
m.addConstr(9 * x0 + 15 * x1 + 21 * x2 >= 44)
m.addConstr(9 * x0 + 21 * x2 + 23 * x3 >= 32)
m.addConstr(9 * x0 + 15 * x1 + 21 * x2 >= 32)
m.addConstr(9 * x0 + 15 * x1 + 21 * x2 + 23 * x3 >= 32)

m.addConstr(-9 * x0 + 7 * x2 >= 0)
m.addConstr(7 * x0 - 9 * x1 >= 0)

m.addConstr(10 * x0 + 7 * x2 + 20 * x3 <= 63)
m.addConstr(7 * x1 + 7 * x2 + 20 * x3 <= 134)
m.addConstr(9 * x0 + 23 * x3 <= 65)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hank: ", x0.varValue)
    print("Peggy: ", x1.varValue)
    print("Paul: ", x2.varValue)
    print("Dale: ", x3.varValue)
else:
    print("No solution found")
