
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
    sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")
    milkshakes = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="milkshakes")

    # Set objective function
    m.setObjective(5*cheeseburgers + 5*sashimi + 3*milkshakes, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*cheeseburgers + 6*milkshakes >= 19, "c0")
    m.addConstr(3*cheeseburgers + 9*sashimi >= 14, "c1")
    m.addConstr(3*cheeseburgers + 9*sashimi + 6*milkshakes >= 14, "c2")
    m.addConstr(2*cheeseburgers + 8*milkshakes >= 5, "c3")
    m.addConstr(10*sashimi + 8*milkshakes >= 5, "c4")
    m.addConstr(2*cheeseburgers + 10*sashimi >= 6, "c5")
    m.addConstr(2*cheeseburgers + 10*sashimi + 8*milkshakes >= 6, "c6")
    m.addConstr(5*cheeseburgers - 4*sashimi >= 0, "c7")
    m.addConstr(-8*sashimi + 1*milkshakes >= 0, "c8")
    m.addConstr(-9*cheeseburgers + 8*milkshakes >= 0, "c9")
    m.addConstr(3*cheeseburgers + 9*sashimi + 6*milkshakes <= 39, "c10")
    m.addConstr(10*sashimi + 8*milkshakes <= 41, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cheeseburgers:', cheeseburgers.x)
        print('sashimi:', sashimi.x)
        print('milkshakes:', milkshakes.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
