
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="cheeseburgers", lb=0)  # Fractional amount allowed
    x1 = model.addVar(name="sashimi", lb=0)      # Fractional amount allowed
    x2 = model.addVar(name="milkshakes", lb=0, integrality=gurobi.GRB.INTEGER)  # Integer amount required
    
    # Objective function
    model.setObjective(5*x0 + 5*x1 + 3*x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(3*x0 <= 57)
    model.addConstr(2*x0 <= 47)
    model.addConstr(9*x1 <= 57)
    model.addConstr(10*x1 <= 47)
    model.addConstr(6*x2 <= 57)
    model.addConstr(8*x2 <= 47)
    model.addConstr(3*x0 + 6*x2 >= 19)
    model.addConstr(3*x0 + 9*x1 >= 14)
    model.addConstr(3*x0 + 9*x1 + 6*x2 >= 14)
    model.addConstr(2*x0 + 8*x2 >= 5)
    model.addConstr(10*x1 + 8*x2 >= 5)
    model.addConstr(2*x0 + 10*x1 >= 6)
    model.addConstr(2*x0 + 10*x1 + 8*x2 >= 6)
    model.addConstr(5*x0 - 4*x1 >= 0)
    model.addConstr(-8*x1 + x2 >= 0)
    model.addConstr(-9*x0 + 8*x2 >= 0)
    model.addConstr(3*x0 + 9*x1 + 6*x2 <= 39)
    model.addConstr(10*x1 + 8*x2 <= 41)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cheeseburgers: {x0.varValue}")
        print(f"Sashimi: {x1.varValue}")
        print(f"Milkshakes: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
