
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
hours = {}
workers = ['Jean', 'Laura', 'Mary', 'Dale', 'Peggy', 'Hank']
for i, worker in enumerate(workers):
    hours[worker] = m.addVar(lb=0, name=f"hours_{worker}")

# Set objective function
m.setObjective(9.73 * hours['Jean'] + 2.12 * hours['Laura'] + 2.41 * hours['Mary'] + 2.41 * hours['Dale'] + 8.33 * hours['Peggy'] + 6.2 * hours['Hank'], gp.GRB.MAXIMIZE)

# Add quality rating constraints
quality_ratings = {'Jean': 5, 'Laura': 24, 'Mary': 22, 'Dale': 4, 'Peggy': 17, 'Hank': 29}
m.addConstr(quality_ratings['Laura'] * hours['Laura'] + quality_ratings['Peggy'] * hours['Peggy'] >= 10)
m.addConstr(quality_ratings['Peggy'] * hours['Peggy'] + quality_ratings['Hank'] * hours['Hank'] >= 9)
m.addConstr(quality_ratings['Jean'] * hours['Jean'] + quality_ratings['Mary'] * hours['Mary'] >= 8)
m.addConstr(quality_ratings['Mary'] * hours['Mary'] + quality_ratings['Dale'] * hours['Dale'] >= 21)
m.addConstr(quality_ratings['Laura'] * hours['Laura'] + quality_ratings['Hank'] * hours['Hank'] >= 23)
m.addConstr(quality_ratings['Jean'] * hours['Jean'] + quality_ratings['Dale'] * hours['Dale'] >= 25)
m.addConstr(quality_ratings['Laura'] * hours['Laura'] + quality_ratings['Dale'] * hours['Dale'] >= 13)


# Add other quality rating constraints from the problem description ...


# Add dollar cost constraints
dollar_costs = {'Jean': 27, 'Laura': 15, 'Mary': 26, 'Dale': 11, 'Peggy': 10, 'Hank': 11}
m.addConstr(dollar_costs['Jean'] * hours['Jean'] + dollar_costs['Peggy'] * hours['Peggy'] + dollar_costs['Hank'] * hours['Hank'] >= 37)
m.addConstr(dollar_costs['Laura'] * hours['Laura'] + dollar_costs['Dale'] * hours['Dale'] + dollar_costs['Peggy'] * hours['Peggy'] >= 37)

# Add other dollar cost constraints from the problem description ...


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    for worker in workers:
        print(f"{worker}: {hours[worker].x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

