
import gurobipy as gp

# Create a new model
m = gp.Model("optimize_work_hours")

# Create variables
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")
laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")

# Set objective function
m.setObjective(8*hank + 2*dale + 4*laura + 4*george + 7*peggy + 1*paul, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*dale + 6*peggy >= 31)
m.addConstr(6*peggy + 9*paul >= 42)
m.addConstr(16*laura + 9*paul >= 33)
m.addConstr(16*laura + 6*peggy >= 33)
m.addConstr(5*dale + 16*george + 9*paul >= 41)
m.addConstr(2*hank + 16*laura + 9*paul >= 41)
m.addConstr(2*hank + 5*dale + 9*paul >= 41)
m.addConstr(5*dale + 16*george + 9*paul >= 32)
m.addConstr(2*hank + 16*laura + 9*paul >= 32)
m.addConstr(2*hank + 5*dale + 9*paul >= 32)
m.addConstr(5*dale + 16*george + 9*paul >= 39)
m.addConstr(2*hank + 16*laura + 9*paul >= 39)
m.addConstr(2*hank + 5*dale + 9*paul >= 39)
m.addConstr(2*hank + 6*peggy <= 132)
m.addConstr(16*laura + 6*peggy <= 265)
m.addConstr(2*hank + 16*laura <= 245)
m.addConstr(2*hank + 5*dale <= 61)
m.addConstr(5*dale + 6*peggy <= 130)
m.addConstr(16*laura + 16*george <= 59)
m.addConstr(16*george + 9*paul <= 324)
m.addConstr(16*george + 6*peggy <= 229)
m.addConstr(16*laura + 9*paul <= 109)
m.addConstr(2*hank + 5*dale + 16*laura + 16*george + 6*peggy + 9*paul <= 109)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

