
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x3 = model.addVar(name='x3')  # hours worked by Laura
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x5 = model.addVar(name='x5', vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x6 = model.addVar(name='x6', vtype=gurobi.GRB.INTEGER)  # hours worked by Paul

    # Objective function
    model.setObjective(8 * x1 + 2 * x2 + 4 * x3 + 4 * x4 + 7 * x5 + x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * x1 <= 359)
    model.addConstr(5 * x2 <= 359)
    model.addConstr(16 * x3 <= 359)
    model.addConstr(16 * x4 <= 359)
    model.addConstr(6 * x5 <= 359)
    model.addConstr(9 * x6 <= 359)

    model.addConstr(5 * x2 + 6 * x5 >= 31)
    model.addConstr(6 * x5 + 9 * x6 >= 42)
    model.addConstr(16 * x3 + 9 * x6 >= 33)
    model.addConstr(16 * x3 + 6 * x5 >= 33)
    model.addConstr(5 * x2 + 16 * x4 + 9 * x6 >= 41)
    model.addConstr(2 * x1 + 16 * x3 + 9 * x6 >= 41)
    model.addConstr(2 * x1 + 5 * x2 + 9 * x6 >= 41)
    model.addConstr(5 * x2 + 16 * x4 + 9 * x6 >= 32)
    model.addConstr(2 * x1 + 16 * x3 + 9 * x6 >= 32)
    model.addConstr(2 * x1 + 5 * x2 + 9 * x6 >= 32)
    model.addConstr(5 * x2 + 16 * x4 + 9 * x6 >= 39)
    model.addConstr(2 * x1 + 16 * x3 + 9 * x6 >= 39)
    model.addConstr(2 * x1 + 5 * x2 + 9 * x6 >= 39)

    model.addConstr(2 * x1 + 6 * x5 <= 132)
    model.addConstr(16 * x3 + 6 * x5 <= 265)
    model.addConstr(2 * x1 + 16 * x3 <= 245)
    model.addConstr(2 * x1 + 5 * x2 <= 61)
    model.addConstr(5 * x2 + 6 * x5 <= 130)
    model.addConstr(16 * x3 + 16 * x4 <= 59)
    model.addConstr(16 * x4 + 9 * x6 <= 324)
    model.addConstr(16 * x4 + 6 * x5 <= 229)
    model.addConstr(16 * x3 + 9 * x6 <= 109)
    model.addConstr(2 * x1 + 5 * x2 + 4 * x3 + 16 * x4 + 7 * x5 + x6 <= 109)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
