
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B6")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B12")

# Set the objective function
m.setObjective(9.01*x1 + 5.56*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(22*x1 + 14*x2 >= 51, "total_immunity_min")
m.addConstr(10*x1 - 10*x2 >= 0, "vitamin_b6_over_b12")
m.addConstr(22*x1 + 14*x2 <= 85, "total_immunity_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B6: {x1.x}")
    print(f"Milligrams of Vitamin B12: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
