
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='milligrams of vitamin B6', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='milligrams of vitamin B12', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(9.01 * x1 + 5.56 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(22 * x1 + 14 * x2 >= 51, name='immune_support_min')
    model.addConstr(x1 - x2 >= 0, name='vitamin_constraint')
    model.addConstr(22 * x1 + 14 * x2 <= 85, name='immune_support_max')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Milligrams of vitamin B6: {x1.varValue}')
        print(f'Milligrams of vitamin B12: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
