
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")

# Set objective function
m.setObjective(3.82 * fruit_salads + 7.34 * pickles + 1.02 * hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(26 * fruit_salads + 6 * hot_dogs >= 40)
m.addConstr(29 * pickles + 6 * hot_dogs >= 107)
m.addConstr(26 * fruit_salads + 29 * pickles + 6 * hot_dogs >= 107)
m.addConstr(1 * fruit_salads + 13 * hot_dogs >= 168)
m.addConstr(1 * fruit_salads + 26 * pickles >= 97)
m.addConstr(1 * fruit_salads + 26 * pickles + 13 * hot_dogs >= 97)
m.addConstr(19 * fruit_salads + 5 * hot_dogs >= 119)
m.addConstr(19 * fruit_salads + 28 * pickles + 5 * hot_dogs >= 106)
m.addConstr(25 * fruit_salads + 4 * hot_dogs >= 109)
m.addConstr(25 * fruit_salads + 1 * pickles >= 51)
m.addConstr(1 * pickles + 4 * hot_dogs >= 106)
m.addConstr(25 * fruit_salads + 1 * pickles + 4 * hot_dogs >= 122)
m.addConstr(-10 * fruit_salads + 7 * pickles >= 0)
m.addConstr(-4 * fruit_salads + 5 * hot_dogs >= 0)
m.addConstr(4 * pickles - 8 * hot_dogs >= 0)
m.addConstr(1 * fruit_salads + 26 * pickles <= 440)
m.addConstr(28 * pickles + 5 * hot_dogs <= 375)
m.addConstr(19 * fruit_salads + 28 * pickles <= 286)
m.addConstr(25 * fruit_salads + 4 * hot_dogs <= 277)
m.addConstr(26 * fruit_salads <= 367)
m.addConstr(1 * fruit_salads <= 512)
m.addConstr(19 * fruit_salads <= 447)
m.addConstr(25 * fruit_salads <= 389)
m.addConstr(29 * pickles <= 367)
m.addConstr(26 * pickles <= 512)
m.addConstr(28 * pickles <= 447)
m.addConstr(1 * pickles <= 389)
m.addConstr(6 * hot_dogs <= 367)
m.addConstr(13 * hot_dogs <= 512)
m.addConstr(5 * hot_dogs <= 447)
m.addConstr(4 * hot_dogs <= 389)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

