
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="fruit_salads", lb=0)
x1 = model.addVar(name="pickles", lb=0)
x2 = model.addVar(name="hot_dogs", lb=0)

# Define the objective function
model.setObjective(3.82 * x0 + 7.34 * x1 + 1.02 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(26 * x0 + 29 * x1 + 6 * x2 <= 367)
model.addConstr(x0 + 26 * x1 + 13 * x2 <= 512)
model.addConstr(19 * x0 + 28 * x1 + 5 * x2 <= 447)
model.addConstr(25 * x0 + x1 + 4 * x2 <= 389)
model.addConstr(26 * x0 + 6 * x2 >= 40)
model.addConstr(29 * x1 + 6 * x2 >= 107)
model.addConstr(26 * x0 + 29 * x1 + 6 * x2 >= 107)
model.addConstr(x0 + 13 * x2 >= 168)
model.addConstr(x0 + 26 * x1 >= 97)
model.addConstr(x0 + 26 * x1 + 13 * x2 >= 97)
model.addConstr(19 * x0 + 5 * x2 >= 119)
model.addConstr(19 * x0 + 28 * x1 + 5 * x2 >= 106)
model.addConstr(25 * x0 + 4 * x2 >= 109)
model.addConstr(25 * x0 + x1 >= 51)
model.addConstr(x1 + 4 * x2 >= 106)
model.addConstr(25 * x0 + x1 + 4 * x2 >= 122)
model.addConstr(-10 * x0 + 7 * x1 >= 0)
model.addConstr(-4 * x0 + 5 * x2 >= 0)
model.addConstr(4 * x1 - 8 * x2 >= 0)
model.addConstr(x0 + 26 * x1 <= 440)
model.addConstr(28 * x1 + 5 * x2 <= 375)
model.addConstr(19 * x0 + 28 * x1 <= 286)
model.addConstr(25 * x0 + 4 * x2 <= 277)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Fruit Salads: ", x0.varValue)
    print("Pickles: ", x1.varValue)
    print("Hot Dogs: ", x2.varValue)
else:
    print("The model is infeasible")
