
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
slices_of_pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")
knishes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")


# Set objective function
m.setObjective(9.13 * fruit_salads + 3.0 * slices_of_pizza + 7.04 * knishes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * slices_of_pizza + 8 * knishes >= 52, "fat_constraint1")
m.addConstr(6 * slices_of_pizza - 5 * knishes >= 0, "pizza_knish_ratio")
m.addConstr(4 * fruit_salads + 8 * knishes <= 81, "fat_constraint2")
m.addConstr(14 * slices_of_pizza + 8 * knishes <= 117, "fat_constraint3")
m.addConstr(4 * fruit_salads + 14 * slices_of_pizza + 8 * knishes <= 181, "total_fat_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', fruit_salads.x)
    print('slices_of_pizza:', slices_of_pizza.x)
    print('knishes:', knishes.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

