
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="fruit_salads")
x2 = m.addVar(lb=0, name="slices_of_pizza")
x3 = m.addVar(lb=0, name="knishes")

# Set the objective function
m.setObjective(9.13*x1 + 3.0*x2 + 7.04*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x2 + 8*x3 >= 52, "fat_from_pizza_knishes")
m.addConstr(6*x2 - 5*x3 >= 0, "pizza_knishes_relationship")
m.addConstr(4*x1 + 8*x3 <= 81, "fat_limit_fruit_knishes")
m.addConstr(14*x2 + 8*x3 <= 117, "fat_limit_pizza_knishes")
m.addConstr(4*x1 + 14*x2 + 8*x3 <= 181, "total_fat_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"fruit_salads: {x1.x}")
    print(f"slices_of_pizza: {x2.x}")
    print(f"knishes: {x3.x}")
else:
    print("No optimal solution found")
