
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="fruit_salads", lb=0)  
x2 = model.addVar(name="slices_of_pizza", lb=0)  
x3 = model.addVar(name="knishes", lb=0)  

# Objective function
model.setObjective(9.13 * x1 + 3.0 * x2 + 7.04 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(4 * x1 + 14 * x2 + 8 * x3 <= 181, name="total_fat")
model.addConstr(14 * x2 + 8 * x3 >= 52, name="min_fat_pizza_knishes")
model.addConstr(6 * x2 - 5 * x3 >= 0, name="pizza_knishes_relation")
model.addConstr(4 * x1 + 8 * x3 <= 81, name="fat_fruit_salads_knishes")
model.addConstr(14 * x2 + 8 * x3 <= 117, name="fat_pizza_knishes")
model.addConstr(4 * x1 + 14 * x2 + 8 * x3 <= 117, name="total_fat_limited")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Fruit Salads: ", x1.varValue)
    print("Slices of Pizza: ", x2.varValue)
    print("Knishes: ", x3.varValue)
else:
    print("The model is infeasible")
