
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
pizza = m.addVar(vtype=gp.GRB.INTEGER, name="pizza")
kale_salad = m.addVar(vtype=gp.GRB.INTEGER, name="kale_salad")
green_beans = m.addVar(vtype=gp.GRB.CONTINUOUS, name="green_beans")


# Set objective function
m.setObjective(5.89 * pizza + 2.73 * kale_salad + 3.28 * green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14.48 * pizza + 11.82 * kale_salad >= 29, "fat_constraint1")
m.addConstr(14.48 * pizza + 11.82 * kale_salad + 15.47 * green_beans >= 29, "fat_constraint2")
m.addConstr(10 * pizza - 10 * green_beans >= 0, "pizza_green_beans_constraint")
m.addConstr(7 * pizza - 5 * kale_salad >= 0, "pizza_kale_salad_constraint")

# Add fat upper bound constraint
m.addConstr(14.48 * pizza + 11.82 * kale_salad + 15.47 * green_beans <= 137, "fat_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('pizza:', pizza.x)
    print('kale_salad:', kale_salad.x)
    print('green_beans:', green_beans.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

