
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="slices_of_pizza")
x2 = m.addVar(vtype=GRB.INTEGER, name="kale_salads")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="green_beans")

# Set the objective function
m.setObjective(5.89*x1 + 2.73*x2 + 3.28*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(14.48*x1 + 11.82*x2 >= 29, name="fat_from_pizza_and_salads")
m.addConstr(14.48*x1 + 11.82*x2 + 15.47*x3 >= 29, name="total_fat")
m.addConstr(10*x1 - 10*x3 >= 0, name="pizza_vs_green_beans")
m.addConstr(7*x1 - 5*x2 >= 0, name="pizza_vs_salads")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"slices_of_pizza: {x1.x}")
    print(f"kale_salads: {x2.x}")
    print(f"green_beans: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
