
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='slices_of_pizza', vtype=gurobi.GRB.INTEGER)  # slices of pizza
    x2 = model.addVar(name='kale_salads', vtype=gurobi.GRB.INTEGER)  # kale salads
    x3 = model.addVar(name='green_beans')  # green beans

    # Objective function
    model.setObjective(5.89 * x1 + 2.73 * x2 + 3.28 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14.48 * x1 + 11.82 * x2 + 15.47 * x3 <= 137, name='total_fat')
    model.addConstr(14.48 * x1 + 11.82 * x2 >= 29, name='fat_from_pizza_and_kale')
    model.addConstr(14.48 * x1 + 11.82 * x2 + 15.47 * x3 >= 29, name='fat_from_all')
    model.addConstr(10 * x1 - 10 * x3 >= 0, name='pizza_green_beans_relationship')
    model.addConstr(7 * x1 - 5 * x2 >= 0, name='pizza_kale_relationship')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Slices of pizza: ', x1.varValue)
        print('Kale salads: ', x2.varValue)
        print('Green beans: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
