
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_admins")
    intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")

    # Set objective function
    m.setObjective(1.55 * network_admins + 8.05 * intrusion_analysts, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.29 * network_admins + 3.64 * intrusion_analysts >= 12, "data_integrity_min")
    m.addConstr(1.96 * network_admins + 4.3 * intrusion_analysts >= 6, "cost_min")
    m.addConstr(0.04 * network_admins + 1.27 * intrusion_analysts >= 3, "computational_load_min")
    m.addConstr(2 * network_admins - 5 * intrusion_analysts >= 0, "staffing_ratio")
    m.addConstr(0.29 * network_admins + 3.64 * intrusion_analysts <= 20, "data_integrity_max")
    m.addConstr(1.96 * network_admins + 4.3 * intrusion_analysts <= 22, "cost_max")
    m.addConstr(0.04 * network_admins + 1.27 * intrusion_analysts <= 15, "computational_load_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Network Administrators: %g' % network_admins.x)
        print('Intrusion Analysts: %g' % intrusion_analysts.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

