
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set the objective function
m.setObjective(1.55*x0 + 8.05*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.29*x0 + 3.64*x1 >= 12, "data_integrity_constraint")
m.addConstr(1.96*x0 + 4.3*x1 >= 6, "minimum_cost_constraint")
m.addConstr(0.04*x0 + 1.27*x1 >= 3, "computational_load_constraint")
m.addConstr(2*x0 - 5*x1 >= 0, "additional_linear_constraint")
m.addConstr(0.29*x0 + 3.64*x1 <= 20, "upper_bound_data_integrity")
m.addConstr(1.96*x0 + 4.3*x1 <= 22, "upper_bound_total_cost")
m.addConstr(0.04*x0 + 1.27*x1 <= 15, "upper_bound_computational_load")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Network Administrators: {x0.x}")
    print(f"Intrusion Analysts: {x1.x}")
else:
    print("No optimal solution found.")

