
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.55 * x0 + 8.05 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.29 * x0 + 3.64 * x1 >= 12)
    model.addConstr(1.96 * x0 + 4.3 * x1 >= 6)
    model.addConstr(0.04 * x0 + 1.27 * x1 >= 3)
    model.addConstr(2 * x0 - 5 * x1 >= 0)
    model.addConstr(0.29 * x0 + 3.64 * x1 <= 25)
    model.addConstr(1.96 * x0 + 4.3 * x1 <= 22)
    model.addConstr(0.04 * x0 + 1.27 * x1 <= 15)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Network Administrators: {x0.varValue}")
        print(f"Intrusion Analysts: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
