
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of vitamin D


    # Set objective function
    m.setObjective(7*x0 + 3*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 1*x1 >= 21, "c0")
    m.addConstr(2*x0 + 2*x1 >= 6, "c1")
    m.addConstr(4*x0 + 4*x1 >= 17, "c2")
    m.addConstr(7*x0 - 6*x1 >= 0, "c3")
    m.addConstr(6*x0 + 1*x1 <= 39, "c4")  # Cardiovascular upper bound
    m.addConstr(2*x0 + 2*x1 <= 22, "c5")  # Energy stability upper bound
    m.addConstr(4*x0 + 4*x1 <= 23, "c6")  # Cognitive performance upper bound


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

