
from gurobipy import *

# Create a model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(name="milligrams_of_vitamin_B2", lb=0)
x2 = m.addVar(name="milligrams_of_vitamin_D", lb=0)

# Objective function
m.setObjective(7*x1 + 3*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(6*x1 + x2 >= 21, name="cardiovascular_support_index")
m.addConstr(2*x1 + 2*x2 >= 6, name="energy_stability_index")
m.addConstr(4*x1 + 4*x2 >= 17, name="cognitive_performance_index")
m.addConstr(7*x1 - 6*x2 >= 0, name="vitamin_B2_and_D_relationship")
m.addConstr(6*x1 + x2 <= 39, name="upper_bound_cardiovascular_support")
m.addConstr(2*x1 + 2*x2 <= 22, name="upper_bound_energy_stability")
m.addConstr(4*x1 + 4*x2 <= 23, name="upper_bound_cognitive_performance")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Milligrams of Vitamin D: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
