
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_B2", lb=0)  # Assuming lb=0, no upper bound given
    x2 = model.addVar(name="milligrams_of_vitamin_D", lb=0)  # Assuming lb=0, no upper bound given

    # Define the objective function
    model.setObjective(7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 + x2 >= 21, name="cardiovascular_support_index_min")
    model.addConstr(2 * x1 + 2 * x2 >= 6, name="energy_stability_index_min")
    model.addConstr(4 * x1 + 4 * x2 >= 17, name="cognitive_performance_index_min")
    model.addConstr(7 * x1 - 6 * x2 >= 0, name="vitamin_B2_D_constraint")
    model.addConstr(6 * x1 + x2 <= 39, name="cardiovascular_support_index_max")
    model.addConstr(2 * x1 + 2 * x2 <= 22, name="energy_stability_index_max")
    model.addConstr(4 * x1 + 4 * x2 <= 23, name="cognitive_performance_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
