
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # security onions
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # pen testers
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # patches per day
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # system administrators
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # automatic alerts

    # Objective function
    model.setObjective(1.96 * x0 + 7.31 * x1 + 6.94 * x2 + 9.13 * x3 + 1.07 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x0 + 7 * x1 + 8 * x2 + 3 * x3 + 5 * x4 <= 189)
    model.addConstr(2 * x0 + 2 * x1 + 6 * x2 + 8 * x3 + 10 * x4 <= 104)
    model.addConstr(2 * x0 + 5 * x4 >= 12)
    model.addConstr(3 * x3 + 5 * x4 >= 21)
    model.addConstr(8 * x2 + 5 * x4 >= 14)
    model.addConstr(8 * x2 + 3 * x3 >= 17)
    model.addConstr(7 * x1 + 3 * x3 >= 37)
    model.addConstr(8 * x2 + 3 * x3 + 5 * x4 >= 30)
    model.addConstr(2 * x0 + 8 * x2 + 3 * x3 >= 30)
    model.addConstr(2 * x0 + 3 * x3 + 5 * x4 >= 30)
    model.addConstr(7 * x1 + 2 * x0 + 3 * x3 >= 30)
    model.addConstr(7 * x1 + 2 * x0 + 5 * x4 >= 30)
    model.addConstr(8 * x2 + 3 * x3 + 5 * x4 >= 21)
    model.addConstr(2 * x0 + 8 * x2 + 3 * x3 >= 21)
    model.addConstr(2 * x0 + 3 * x3 + 5 * x4 >= 21)
    model.addConstr(7 * x1 + 2 * x0 + 3 * x3 >= 21)
    model.addConstr(7 * x1 + 2 * x0 + 5 * x4 >= 21)
    model.addConstr(2 * x0 + 7 * x1 + 8 * x2 + 3 * x3 + 5 * x4 >= 21)
    model.addConstr(6 * x2 + 8 * x3 >= 20)
    model.addConstr(2 * x0 + 6 * x2 >= 17)
    model.addConstr(2 * x0 + 8 * x3 >= 10)
    model.addConstr(2 * x0 + 10 * x4 >= 10)
    model.addConstr(8 * x3 + 10 * x4 >= 18)
    model.addConstr(2 * x1 + 6 * x2 >= 17)
    model.addConstr(2 * x0 + 2 * x1 + 6 * x2 + 8 * x3 + 10 * x4 >= 17)
    model.addConstr(2 * x0 + 5 * x4 <= 48)
    model.addConstr(8 * x2 + 3 * x3 <= 177)
    model.addConstr(2 * x0 + 8 * x2 <= 49)
    model.addConstr(7 * x1 + 8 * x2 <= 153)
    model.addConstr(8 * x2 + 3 * x3 + 5 * x4 <= 106)
    model.addConstr(6 * x2 + 8 * x3 <= 91)
    model.addConstr(2 * x1 + 6 * x2 <= 49)
    model.addConstr(2 * x1 + 10 * x4 <= 31)
    model.addConstr(8 * x3 + 10 * x4 <= 48)
    model.addConstr(2 * x0 + 2 * x1 + 8 * x3 <= 49)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Onions: {x0.varValue}")
        print(f"Pen Testers: {x1.varValue}")
        print(f"Patches per Day: {x2.varValue}")
        print(f"System Administrators: {x3.varValue}")
        print(f"Automatic Alerts: {x4.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
