
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_work_hours")

    # Create variables
    hank = m.addVar(name="hank")
    laura = m.addVar(name="laura", vtype=gp.GRB.INTEGER)
    george = m.addVar(name="george")
    jean = m.addVar(name="jean")
    dale = m.addVar(name="dale")

    # Set objective function
    m.setObjective(3.24 * hank + 2.29 * laura + 1.49 * george + 1.05 * jean + 9.73 * dale, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3.51 * hank + 1.84 * jean >= 41)
    m.addConstr(11.46 * laura + 1.84 * jean >= 60)
    m.addConstr(3.51 * hank + 11.46 * laura >= 43)
    m.addConstr(1.84 * jean + 7.1 * dale >= 64)
    m.addConstr(9.55 * george + 1.84 * jean >= 64)
    m.addConstr(3.51 * hank + 9.55 * george >= 58)
    m.addConstr(3.51 * hank + 7.1 * dale >= 32)
    m.addConstr(3.51 * hank + 9.55 * george + 7.1 * dale >= 51)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george >= 51)
    m.addConstr(3.51 * hank + 1.84 * jean + 7.1 * dale >= 51)
    m.addConstr(9.55 * george + 1.84 * jean + 7.1 * dale >= 51)
    m.addConstr(3.51 * hank + 9.55 * george + 7.1 * dale >= 53)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george >= 53)
    m.addConstr(3.51 * hank + 1.84 * jean + 7.1 * dale >= 53)
    m.addConstr(9.55 * george + 1.84 * jean + 7.1 * dale >= 53)
    m.addConstr(3.51 * hank + 9.55 * george + 7.1 * dale >= 62)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george >= 62)
    m.addConstr(3.51 * hank + 1.84 * jean + 7.1 * dale >= 62)
    m.addConstr(9.55 * george + 1.84 * jean + 7.1 * dale >= 62)
    m.addConstr(3.51 * hank + 9.55 * george + 7.1 * dale >= 50)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george >= 50)
    m.addConstr(3.51 * hank + 1.84 * jean + 7.1 * dale >= 50)
    m.addConstr(9.55 * george + 1.84 * jean + 7.1 * dale >= 50)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george + 1.84 * jean + 7.1 * dale >= 50)
    m.addConstr(2.86 * hank + 5.09 * dale >= 61)
    m.addConstr(12.88 * laura + 5.09 * dale >= 48)
    m.addConstr(12.88 * laura + 7.15 * jean >= 43)
    m.addConstr(2.86 * hank + 12.88 * laura + 4.78 * george + 7.15 * jean + 5.09 * dale >= 43)
    m.addConstr(-5 * hank + 3 * george >= 0)
    m.addConstr(-5 * jean + 3 * dale >= 0)
    m.addConstr(3.51 * hank + 11.46 * laura + 9.55 * george <= 208)
    m.addConstr(2.86 * hank + 4.78 * george <= 264)
    m.addConstr(2.86 * hank + 12.88 * laura <= 94)
    m.addConstr(2.86 * hank + 5.09 * dale <= 298)
    m.addConstr(7.15 * jean + 5.09 * dale <= 245)
    m.addConstr(2.86 * hank + 7.15 * jean <= 253)
    m.addConstr(4.78 * george + 7.15 * jean <= 379)
    m.addConstr(12.88 * laura + 5.09 * dale <= 163)
    m.addConstr(12.88 * laura + 7.15 * jean <= 205)
    m.addConstr(2.86 * hank + 7.15 * jean + 5.09 * dale <= 192)
    m.addConstr(2.86 * hank + 12.88 * laura + 4.78 * george <= 388)
    m.addConstr(2.86 * hank + 12.88 * laura + 7.15 * jean <= 158)
    m.addConstr(2.86 * hank + 4.78 * george + 7.15 * jean <= 82)
    m.addConstr(4.78 * george + 7.15 * jean + 5.09 * dale <= 139)
    m.addConstr(2.86 * hank + 4.78 * george + 5.09 * dale <= 90)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
