
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="bean stalks")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="zucchini vines")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="aloe vera")

    # Set objective function
    m.setObjective(6.8 * x0 + 7.41 * x1 + 3.77 * x2 + 7.1 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13 * x0 + 1 * x1 >= 37)
    m.addConstr(13 * x0 + 13 * x2 + 23 * x3 >= 45)
    m.addConstr(26 * x0 + 4 * x3 >= 47)
    m.addConstr(26 * x0 + 8 * x1 >= 37)
    m.addConstr(15 * x2 + 4 * x3 >= 31)
    m.addConstr(26 * x0 + 8 * x1 + 4 * x3 >= 38)
    m.addConstr(13 * x0 + 23 * x3 <= 145)
    m.addConstr(13 * x0 + 1 * x1 <= 99)
    m.addConstr(13 * x0 + 13 * x2 <= 142)
    m.addConstr(1 * x1 + 13 * x2 <= 166)
    m.addConstr(13 * x0 + 1 * x1 + 23 * x3 <= 118)
    m.addConstr(13 * x0 + 13 * x2 + 23 * x3 <= 138)
    m.addConstr(1 * x1 + 13 * x2 + 23 * x3 <= 109)
    m.addConstr(13 * x0 + 1 * x1 + 13 * x2 + 23 * x3 <= 109)
    m.addConstr(8 * x1 + 4 * x3 <= 73)
    m.addConstr(15 * x2 + 4 * x3 <= 109)
    m.addConstr(26 * x0 + 8 * x1 + 4 * x3 <= 104)
    m.addConstr(26 * x0 + 8 * x1 + 15 * x2 + 4 * x3 <= 104)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
