
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="bean_stalks", vtype=gp.GRB.INTEGER)  # bean stalks
x1 = m.addVar(name="lilies", vtype=gp.GRB.INTEGER)    # lilies
x2 = m.addVar(name="zucchini_vines", vtype=gp.GRB.INTEGER)  # zucchini vines
x3 = m.addVar(name="aloe_vera", vtype=gp.GRB.INTEGER)    # aloe vera

# Define the objective function
m.setObjective(6.8*x0 + 7.41*x1 + 3.77*x2 + 7.1*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(13*x0 + x1 >= 37)  # total beauty from bean stalks and lilies
m.addConstr(13*x0 + 13*x2 + 23*x3 >= 45)  # total beauty from bean stalks, zucchini vines, aloe vera
m.addConstr(26*x0 + 4*x3 >= 47)  # total resilience from bean stalks and aloe vera
m.addConstr(26*x0 + 8*x1 >= 37)  # total resilience from bean stalks and lilies
m.addConstr(15*x2 + 4*x3 >= 31)  # total resilience from zucchini vines and aloe vera
m.addConstr(26*x0 + 8*x1 + 4*x3 >= 38)  # total resilience from bean stalks, lilies, aloe vera
m.addConstr(13*x0 + 23*x3 <= 145)  # total beauty from bean stalks and aloe vera
m.addConstr(13*x0 + x1 <= 99)  # total beauty from bean stalks and lilies
m.addConstr(13*x0 + 13*x2 <= 142)  # total beauty from bean stalks and zucchini vines
m.addConstr(x1 + 13*x2 + 23*x3 <= 166)  # total beauty from lilies, zucchini vines, aloe vera
m.addConstr(13*x0 + x1 + 23*x3 <= 118)  # total beauty from bean stalks, lilies, aloe vera
m.addConstr(13*x0 + 13*x2 + 23*x3 <= 138)  # total beauty from bean stalks, zucchini vines, aloe vera
m.addConstr(x1 + 13*x2 + 23*x3 <= 109)  # total beauty from lilies, zucchini vines, aloe vera
m.addConstr(13*x0 + x1 + 13*x2 + 23*x3 <= 109)  # total beauty from all
m.addConstr(8*x1 + 4*x3 <= 73)  # total resilience from lilies and aloe vera
m.addConstr(15*x2 + 4*x3 <= 109)  # total resilience from zucchini vines and aloe vera
m.addConstr(26*x0 + 8*x1 + 4*x3 <= 104)  # total resilience from bean stalks, lilies, aloe vera
m.addConstr(26*x0 + 8*x1 + 15*x2 + 4*x3 <= 104)  # total resilience from all

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Bean Stalks: ", x0.varValue)
    print("Lilies: ", x1.varValue)
    print("Zucchini Vines: ", x2.varValue)
    print("Aloe Vera: ", x3.varValue)
else:
    print("The model is infeasible")
