
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("maximize_food")

    # Create variables
    chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
    eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")


    # Set objective function
    m.setObjective(6 * chicken_thighs + 6 * eggs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19 * chicken_thighs + 2 * eggs >= 88, "calcium_min")
    m.addConstr(14 * chicken_thighs + 2 * eggs >= 23, "umami_min")
    m.addConstr(13 * chicken_thighs + 6 * eggs >= 77, "tastiness_min")
    m.addConstr(-7 * chicken_thighs + 10 * eggs >= 0, "constraint4")
    m.addConstr(19 * chicken_thighs + 2 * eggs <= 137, "calcium_max")
    m.addConstr(14 * chicken_thighs + 2 * eggs <= 95, "umami_max")
    m.addConstr(13 * chicken_thighs + 6 * eggs <= 130, "tastiness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('chicken_thighs:', chicken_thighs.x)
        print('eggs:', eggs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
