
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_thighs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")

# Set the objective function
m.setObjective(6*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(19*x1 + 2*x2 >= 88, "calcium_min")
m.addConstr(14*x1 + 2*x2 >= 23, "umami_min")
m.addConstr(13*x1 + 6*x2 >= 77, "tastiness_min")
m.addConstr(-7*x1 + 10*x2 >= 0, "linear_combination")
m.addConstr(19*x1 + 2*x2 <= 137, "calcium_max")
m.addConstr(14*x1 + 2*x2 <= 95, "umami_max")
m.addConstr(13*x1 + 6*x2 <= 130, "tastiness_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken thighs: {x1.x}")
    print(f"Eggs: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
