
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='chicken_thighs', lb=0)  # Assuming non-negative
x2 = model.addVar(name='eggs', lb=0)  # Assuming non-negative

# Define the objective function
model.setObjective(6 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(19 * x1 + 2 * x2 >= 88, name='calcium_constraint')
model.addConstr(14 * x1 + 2 * x2 >= 23, name='umami_index_constraint')
model.addConstr(13 * x1 + 6 * x2 >= 77, name='tastiness_rating_constraint')
model.addConstr(-7 * x1 + 10 * x2 >= 0, name='linear_combination_constraint')
model.addConstr(19 * x1 + 2 * x2 <= 137, name='upper_bound_calcium_constraint')
model.addConstr(14 * x1 + 2 * x2 <= 95, name='upper_bound_umami_index_constraint')
model.addConstr(13 * x1 + 6 * x2 <= 130, name='upper_bound_tastiness_rating_constraint')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Chicken thighs: ', x1.varValue)
    print('Eggs: ', x2.varValue)
else:
    print('The model is infeasible')
