
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    protein_bars = m.addVar(lb=0, name="protein_bars")
    cantaloupes = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cantaloupes")


    # Set objective function
    m.setObjective(4.7 * protein_bars + 2.79 * cantaloupes, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(24 * protein_bars + 21 * cantaloupes >= 29, "c0")
    m.addConstr(2 * protein_bars + 9 * cantaloupes >= 49, "c1")
    m.addConstr(11 * protein_bars + 10 * cantaloupes >= 40, "c2")
    m.addConstr(-3 * protein_bars + 8 * cantaloupes >= 0, "c3")
    m.addConstr(24 * protein_bars + 21 * cantaloupes <= 55, "c4")
    m.addConstr(2 * protein_bars + 9 * cantaloupes <= 178, "c5")
    m.addConstr(11 * protein_bars + 10 * cantaloupes <= 107, "c6")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('protein_bars:', protein_bars.x)
        print('cantaloupes:', cantaloupes.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
