
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables: x0 is continuous and x1 is integer
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="protein_bars")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="cantaloupes")

# Set the objective function
m.setObjective(4.7*x0 + 2.79*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(24*x0 + 21*x1 >= 29, "umami_index_min")
m.addConstr(2*x0 + 9*x1 >= 49, "carbohydrates_min")
m.addConstr(11*x0 + 10*x1 >= 40, "healthiness_rating_min")
m.addConstr(-3*x0 + 8*x1 >= 0, "mix_constraint")
m.addConstr(24*x0 + 21*x1 <= 55, "umami_index_max")
m.addConstr(2*x0 + 9*x1 <= 178, "carbohydrates_max")
m.addConstr(11*x0 + 10*x1 <= 107, "healthiness_rating_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Protein bars: {x0.x}")
    print(f"Cantaloupes: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
