
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="protein_bars", lb=0, ub=None)  # Continuous
    x2 = model.addVar(name="cantaloupes", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Integer

    # Define the objective function
    model.setObjective(4.7 * x1 + 2.79 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(24 * x1 + 21 * x2 >= 29, name="umami_min")
    model.addConstr(2 * x1 + 9 * x2 >= 49, name="carbohydrates_min")
    model.addConstr(11 * x1 + 10 * x2 >= 40, name="healthiness_min")
    model.addConstr(-3 * x1 + 8 * x2 >= 0, name="linear_combination")
    model.addConstr(24 * x1 + 21 * x2 <= 55, name="umami_max")
    model.addConstr(2 * x1 + 9 * x2 <= 178, name="carbohydrates_max")
    model.addConstr(11 * x1 + 10 * x2 <= 107, name="healthiness_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein bars: {x1.varValue}")
        print(f"Cantaloupes: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
